/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.Daily;
import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.Interval;
import ibm.nways.analysis.dpEngine.InvalidScheduleTypeException;
import ibm.nways.analysis.dpEngine.InvalidTimeException;
import ibm.nways.analysis.dpEngine.Scheduled;
import ibm.nways.analysis.dpEngine.Scheduler;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class BasicScheduler
extends Thread
implements Scheduler {
    public static final int DAILY = 1;
    public static final int WEEKLY = 2;
    private Vector timers;
    private Vector days;
    private SimpleTimeZone gmt;
    private GregorianCalendar cal;
    private long midnight;
    private Scheduled defaultScheduled;
    private int currentTimerIndex;
    private boolean WaitingForStart = true;
    private Timer currentTimer;
    private int numTimers;
    private int scheduleType;
    private int currentDay;

    public void terminate() {
        this.interrupt();
    }

    public BasicScheduler(int n, Scheduled scheduled) {
        this.scheduleType = n;
        if (this.scheduleType == 1) {
            this.timers = new Vector();
        } else {
            this.days = new Vector();
            this.timers = null;
        }
        String[] stringArray = TimeZone.getAvailableIDs(0);
        this.gmt = new SimpleTimeZone(0, stringArray[0]);
        this.cal = new GregorianCalendar(this.gmt);
        this.cal.get(11);
        this.defaultScheduled = scheduled;
    }

    private long now() {
        long l = System.currentTimeMillis() - this.midnight;
        return l;
    }

    private long getMidnight() {
        long l = System.currentTimeMillis();
        this.cal.setTime(new Date());
        int n = this.cal.get(11);
        int n2 = this.cal.get(12);
        int n3 = this.cal.get(13);
        return l -= (long)(n3 * 1000 + n2 * 60 * 1000 + n * 60 * 60 * 1000);
    }

    private int getDay() {
        this.cal.setTime(new Date());
        return this.cal.get(7);
    }

    public Timer makeTimer(Interval interval) {
        long l = this.getMidnight();
        this.cal.set(11, interval.beginHour());
        this.cal.set(12, interval.beginMinute());
        this.cal.set(13, 0);
        long l2 = this.cal.getTime().getTime();
        this.cal.set(11, interval.endHour());
        this.cal.set(12, interval.endMinute());
        this.cal.set(13, 59);
        this.cal.set(14, 900);
        long l3 = this.cal.getTime().getTime();
        Timer timer = new Timer(l2 - l, l3 - l, this.defaultScheduled, interval.state);
        return timer;
    }

    private void update(int n, Vector vector) {
        Vector vector2 = n == -1 ? this.timers : (Vector)this.days.elementAt(n - 1);
        int n2 = vector.size();
        vector2.removeAllElements();
        int n3 = 0;
        while (n3 < n2) {
            Interval interval = (Interval)vector.elementAt(n3);
            vector2.addElement(this.makeTimer(interval));
            ++n3;
        }
        this.midnight = this.getMidnight();
        this.numTimers = this.timers.size();
        this.recheckTimers();
        this.notifyAll();
    }

    public synchronized void updateSchedule(Vector vector) throws InvalidTimeException, InvalidScheduleTypeException {
        if (this.scheduleType == 1) {
            this.update(-1, vector);
            return;
        }
        throw new InvalidScheduleTypeException();
    }

    public synchronized void updateSchedule(int n, Daily daily) throws InvalidTimeException, InvalidScheduleTypeException {
        if (this.scheduleType == 2) {
            Vector vector = daily.retrieveIntervals();
            this.update(n, vector);
            return;
        }
        throw new InvalidScheduleTypeException();
    }

    private void checkTimers() {
        this.notifyAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.isInterrupted()) {
            BasicScheduler basicScheduler = this;
            synchronized (basicScheduler) {
                Object var2_2;
                block34: {
                    block33: {
                        if (this.numTimers == 0) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                            catch (Exception exception) {}
                            this.recheckTimers();
                        } else {
                            if (this.currentTimerIndex == 0) {
                                this.midnight = this.getMidnight();
                                if (this.scheduleType == 2) {
                                    switch (this.currentDay) {
                                        case 1: {
                                            this.currentDay = 2;
                                            break;
                                        }
                                        case 2: {
                                            this.currentDay = 3;
                                            break;
                                        }
                                        case 3: {
                                            this.currentDay = 4;
                                            break;
                                        }
                                        case 4: {
                                            this.currentDay = 5;
                                            break;
                                        }
                                        case 5: {
                                            this.currentDay = 6;
                                            break;
                                        }
                                        case 6: {
                                            this.currentDay = 7;
                                            break;
                                        }
                                        case 7: {
                                            this.currentDay = 1;
                                            break;
                                        }
                                    }
                                    this.timers = (Vector)this.days.elementAt(this.currentDay - 1);
                                    this.numTimers = this.timers.size();
                                }
                            }
                            this.currentTimer = (Timer)this.timers.elementAt(this.currentTimerIndex);
                            ++this.currentTimerIndex;
                            if (this.currentTimerIndex >= this.numTimers) {
                                this.currentTimerIndex = 0;
                            }
                            try {
                                long l = this.now();
                                if (this.WaitingForStart) {
                                    long l2 = this.currentTimer.beginTime - l;
                                    if (l2 < 0L && this.currentTimerIndex == 1) {
                                        if (this.scheduleType == 2) {
                                            this.currentTimerIndex = 0;
                                            var2_2 = null;
                                            break block33;
                                        }
                                        l2 += 86400000L;
                                    } else if (l2 < 0L) {
                                        this.recheckTimers();
                                        break block34;
                                    }
                                    if (DpInterfaceImpl.trace_schedule) {
                                        DpInterfaceImpl.LogMessage("waiting for begin: " + l2);
                                    }
                                    this.wait(l2);
                                    if (this.now() < this.currentTimer.beginTime) {
                                        this.recheckTimers();
                                    } else {
                                        this.currentTimer.obj.intervalStarted(this.currentTimer.state);
                                        this.WaitingForStart = false;
                                    }
                                }
                                this.WaitingForStart = true;
                            }
                            catch (Exception exception) {
                                this.recheckTimers();
                            }
                        }
                        continue;
                    }
                    continue;
                }
                var2_2 = null;
            }
        }
        return;
    }

    private void recheckTimers() {
        Vector vector = this.scheduleType == 2 ? (Vector)this.days.elementAt(this.getDay() - 1) : this.timers;
        this.midnight = this.getMidnight();
        this.numTimers = this.timers.size();
        this.currentTimerIndex = 0;
        this.WaitingForStart = true;
        long l = this.now();
        int n = 0;
        while (n < this.numTimers) {
            Timer timer = (Timer)vector.elementAt(n);
            if (timer.beginTime > l) {
                timer.obj.intervalStarted(timer.state);
                this.currentTimerIndex = n;
                this.WaitingForStart = true;
                return;
            }
            ++n;
        }
    }

    class Timer {
        protected long beginTime;
        protected long endTime;
        protected Scheduled obj;
        protected Object state;

        Timer(long l, long l2, Scheduled scheduled, Object object) {
            BasicScheduler.this = BasicScheduler.this;
            this.beginTime = l;
            this.endTime = l2;
            this.obj = scheduled;
            this.state = object;
        }
    }
}

